<?php
class PortalFront extends Portal
{
  public $zalogowany = null;
  
  function __construct($host, $user, $pass, $db)
  {
    $this->dbo = $this->initDB($host, $user, $pass, $db);
    $this->zalogowany = $this->getActualUser();
  }
  
  function getActualUser()
  {
    if(isset($_SESSION['zalogowany'])){
      return $_SESSION['zalogowany'];
    }
    else{
      return null;
    }
  }
  
  function setMessage($komunikat)
  {
    $_SESSION['komunikat'] = $komunikat;
  }
  
  function getMessage()
  {
    if(isset($_SESSION['komunikat'])){
      $komunikat = $_SESSION['komunikat'];
      unset($_SESSION['komunikat']);
      return $komunikat;
    }
    else {
      return null;
    }
  }

  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy użytkownik już jest zalogowany
    if($this->zalogowany){
      return NO_LOGIN_REQUIRED;
    }
    
    //Sprawdzenie czy zostały przekazane parametry
    if(!isset($_POST["email"]) || !isset($_POST["haslo"])){
      return FORM_DATA_MISSING;
    }
    
    $user = $_POST["email"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie długości przekazanych ciągów
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    //$userNameLength = strlen(utf8_decode($user));
    //$userPassLength = strlen(utf8_decode($pass));
    //lub
    $userEmailLength = mb_strlen($user, 'utf8');
    $userPassLength = mb_strlen($pass, 'utf8');
    
    if($userEmailLength < 5 || $userEmailLength > 250 ||
     $userPassLength < 6 || $userPassLength > 100){
      return ACTION_FAILED;
    }
  
    //Zabezpieczenie znaków specjalnych w parametrach
    $email = $this->dbo->real_escape_string($user);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzającego poprawność danych
    $query = "SELECT `Id`, `Imię`, `Nazwisko`, `Hasło` "
           . "FROM Klienci WHERE `Email`='$email'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wyników zapytania.
    if($result->num_rows <> 1){
      //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników
      return ACTION_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[3];
      //Wersja bez kodowania haseł
      if($pass != $pass_db){
      //Wersja z kodowaniem haseł
      //if(crypt($pass, $pass_db) != $pass_db){
        return ACTION_FAILED;
      }
      else{
        $nazwa = $row[1] . ' ' . $row[2];
        $_SESSION['zalogowany'] = new User($row[0], $nazwa);
        return ACTION_OK;
      }
    }
  }
  
  function logout()
  {
    $this->zalogowany = null;
    if(isset($_SESSION['zalogowany'])){
      unset($_SESSION['zalogowany']);
      
      //Jeśli sesja ma być usunięta (co wiąże się też z usunięciem koszyka):
      /*
      if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();
      */
    }
  }
  
  function showRegistrationForm()
  {
    $reg = new Registration($this->dbo);
    return $reg->showRegistrationForm();
  }
  
  function registerUser()
  {
    $reg = new Registration($this->dbo);
    return $reg->registerUser();
  }
  
  function showSearchForm()
  {
    $autor = filter_input(INPUT_GET, 'autor', FILTER_SANITIZE_SPECIAL_CHARS);
    $tytuł = filter_input(INPUT_GET, 'tytul', FILTER_SANITIZE_SPECIAL_CHARS);
    include 'templates/searchForm.php';
  }
  
  function showSearchResults()
  {
    //Określenie warunku dla autora
    if(isset($_GET['autor']) && $_GET['autor'] != ''){
      //Tu lub po przefiltrowaniu dodatkowa weryfikacja poprawności parametru
      $autor = filter_input(INPUT_GET, 'autor', 
                            FILTER_SANITIZE_SPECIAL_CHARS);
      $cond1 = " AND Autorzy.`Nazwa` LIKE '%$autor%' ";
    }
    else{
      $cond1 = '';
    }
    
    //Określenie warunku dla tytułu
    if(isset($_GET['tytul']) && $_GET['tytul'] != ''){
      //Tu lub po przefiltrowaniu dodatkowa weryfikacja poprawności parametru
      $tytul = filter_input(INPUT_GET, 'tytul', 
                            FILTER_SANITIZE_SPECIAL_CHARS);
      $cond2 = " AND Ksiazki.`Tytuł` LIKE '%$tytul%' ";
    }
    else{
      $cond2 = '';
    }
    
    //Formowanie zapytania
    $query  = 'SELECT k.`Tytuł`, GROUP_CONCAT(a.`Nazwa`) AS `Autor`, '
            . 'k.`ISBN`, w.`Nazwa` AS `Wydawnictwo`, k.`Cena`, '
            . 'k.`Id` AS `Id` '
            . 'FROM Ksiazki k JOIN Wydawnictwa w ON (k.WydawnictwoId = w.Id) '
            . 'JOIN KsiazkiAutorzy ka ON (ka.`KsiążkaId` = k.`Id`) '
            . 'JOIN Autorzy a ON (ka.`AutorId` = a.`Id`) WHERE 1=1 '
            . $cond1.$cond2
            . 'GROUP BY k.`Id` ORDER BY `Autor`, `Tytuł`, `Wydawnictwo`';

    //Wykonanie zapytania i sprawdzenie wyników
    $komunikat = false;
    if(!$result = $this->dbo->query($query)){
      $komunikat = 'Wyniki wyszukiwania nie są obecnie dostępne.';
    } else if($result->num_rows < 1) {
      $komunikat = 'Brak książek spełniających podane kryteria.';
    }
            
    //Wyświetlenie rezultatów wyszukiwania
    include 'templates/searchResults.php';
  }
  
  function showBookDetails()
  {
    //Sprawdzenie poprawności identyfikatora książki (parametr id)
    if(!isset($_GET['id']) || ($id = intval($_GET['id'])) < 1){
      $komunikat = 'Brak książki o podanym identyfikatorze.';
    } else {
      //Formowanie zapytania
      $query = 'SELECT `Tytuł`, `ISBN`, `Rok wydania` AS `Rok`, `Opis`, `Cena`,'
             . 'w.`Nazwa` AS `Wydawnictwo`, GROUP_CONCAT(a.`Nazwa`) AS `Autor`,'
             . 'k.`Id` AS `Id` FROM Ksiazki k '
             . 'JOIN KsiazkiAutorzy ka ON (k.`Id`=ka.`KsiążkaId` AND k.`id`='.$id.')'
             . 'JOIN Autorzy a ON (a.`Id` = ka.`AutorId`) '
             . 'JOIN Wydawnictwa w ON (w.`Id`=k.`WydawnictwoId`) GROUP BY k.`Id`';

      //Umieszczenie wyników zapytania w tabeli
      if($result = $this->dbo->query($query)){
        if($row = $result->fetch_assoc()){
          $komunikat = false;
        }
        else{
          $komunikat = 'Brak książki o podanym identyfikatorze.';
        }
      }    
      else{
        $komunikat = 'Błąd serwera. Dane szczegółowe nie są dostępne.';
      }
    }
    include 'templates/bookDetails.php';
  }
  
  function addToBasket()
  {
    $basket = new Basket($this->dbo);
    return $basket->add();
  }
  
  function showBasket()
  {
    $basket = new Basket($this->dbo);
    $basket->show('Zawartość koszyka', true);
  }
  
  function modifyBasket()
  {
    $basket = new Basket($this->dbo);
    $basket->modify();
  }
  
  function checkout()
  {
    if(isset($_SESSION['zalogowany'])){
      $basket = new Basket($this->dbo);
      $basket->show('Podsumowanie zamówienia', false);
    }
    else{
      include 'templates/orderNoLoginInfoDiv.php';
    }
  }
}
?>